/*=============================================
CARGAR LA TABLA DINÁMICA DE VENTAS
=============================================*/

// $.ajax({

// 	url: "ajax/datatable-ventas.ajax.php",
// 	success:function(respuesta){
		
// 		console.log("respuesta", respuesta);

// 	}

// })// 

$('.tablaVentas').DataTable( {
    "ajax": "ajax/datatable-ventas.ajax.php",
    "deferRender": true,
	"retrieve": true,
	"processing": true,
	"info": false,
	 "language": {

			"sProcessing":     "Procesando...",
			"sLengthMenu":     "Mostrar _MENU_ registros",
			"sZeroRecords":    "No se encontraron resultados",
			"sEmptyTable":     "Ningún dato disponible en esta tabla",
			"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
			"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
			"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
			"sInfoPostFix":    "",
			"sSearch":         "Buscar:",
			"sUrl":            "",
			"sInfoThousands":  ",",
			"sLoadingRecords": "Cargando...",
			"oPaginate": {
			"sFirst":    "Primero",
			"sLast":     "Último",
			"sNext":     "Siguiente",
			"sPrevious": "Anterior"
			},
			"oAria": {
				"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
				"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			}

	}

} );

/*=============================================
AGREGANDO PRODUCTOS A LA VENTA DESDE LA TABLA
=============================================*/

$(".tablaVentas tbody").on("click", "button.agregarProducto", function(){

	var idProducto = $(this).attr("idProducto");

	$(this).removeClass("btn-primary agregarProducto");

	$(this).addClass("btn-default");

	var datos = new FormData();
    datos.append("idProducto", idProducto);

     $.ajax({

     	url:"ajax/productos.ajax.php",
      	method: "POST",
      	data: datos,
      	cache: false,
      	contentType: false,
      	processData: false,
      	dataType:"json",
      	success:function(respuesta){

      	    var descripcion = respuesta["descripcion"];
          	var stock = respuesta["stock"];
          	var precio = respuesta["precio_venta"];

          	/*=============================================
          	EVITAR AGREGAR PRODUCTO CUANDO EL STOCK ESTÁ EN CERO
          	=============================================*/

          	if(stock == 0){

      			swal({
			      title: "No hay stock disponible",
			      type: "error",
			      confirmButtonText: "¡Cerrar!"
			    });

			    $("button[idProducto='"+idProducto+"']").addClass("btn-primary agregarProducto");

			    return;

          	}

          	$(".nuevoProducto").append(

          	'<div class="row" style="padding:5px 15px">'+

			  '<!-- Descripción del producto -->'+
	          
	          '<div class="col-xs-6" style="padding-right:0px">'+
	          
	            '<div class="input-group">'+
	              
	              '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarProducto" idProducto="'+idProducto+'"><i class="fa fa-times"></i></button></span>'+

	              '<input type="text" class="form-control nuevaDescripcionProducto" idProducto="'+idProducto+'" name="agregarProducto" value="'+descripcion+'" readonly required>'+

	            '</div>'+

	          '</div>'+

	          '<!-- Cantidad del producto -->'+

	          '<div class="col-xs-3">'+
	            
	             '<input type="number" class="form-control nuevaCantidadProducto" name="nuevaCantidadProducto" min="1"  stock="'+stock+'" nuevoStock="'+Number(stock-1)+'" required>'+

	          '</div>' +

	          '<!-- Precio del producto -->'+

	          '<div class="col-xs-3 ingresoPrecio" style="padding-left:0px">'+

	            '<div class="input-group">'+

	              '<span class="input-group-addon"><i class="ion ion-social-usd"></i></span>'+
	                 
	              '<input type="text" class="form-control nuevoPrecioProducto" onchange="cambios()" precioReal="'+precio+'" name="nuevoPrecioProducto" value="'+precio+'" required>'+
	 
	            '</div>'+
	             
	          '</div>'+

	        '</div>') 

	        // SUMAR TOTAL DE PRECIOS

	        sumarTotalPrecios()

	        // AGREGAR IMPUESTO

	        agregarImpuesto()

	        // AGRUPAR PRODUCTOS EN FORMATO JSON

	        listarProductos()

	        // PONER FORMATO AL PRECIO DE LOS PRODUCTOS

	        $(".nuevoPrecioProducto").number(true, 0);


			localStorage.removeItem("quitarProducto");

      	}

     })

});

function cambios(){
	sumarTotalPrecios();

	        // AGREGAR IMPUESTO

	        agregarImpuesto();

	        // AGRUPAR PRODUCTOS EN FORMATO JSON

	        listarProductos();
}

/*=============================================
CUANDO CARGUE LA TABLA CADA VEZ QUE NAVEGUE EN ELLA
=============================================*/

$(".tablaVentas").on("draw.dt", function(){

	if(localStorage.getItem("quitarProducto") != null){

		var listaIdProductos = JSON.parse(localStorage.getItem("quitarProducto"));

		for(var i = 0; i < listaIdProductos.length; i++){

			$("button.recuperarBoton[idProducto='"+listaIdProductos[i]["idProducto"]+"']").removeClass('btn-default');
			$("button.recuperarBoton[idProducto='"+listaIdProductos[i]["idProducto"]+"']").addClass('btn-primary agregarProducto');

		}


	}


})


/*=============================================
QUITAR PRODUCTOS DE LA VENTA Y RECUPERAR BOTÓN
=============================================*/

var idQuitarProducto = [];

localStorage.removeItem("quitarProducto");

$(".formularioVenta").on("click", "button.quitarProducto", function(){

	$(this).parent().parent().parent().parent().remove();

	var idProducto = $(this).attr("idProducto");

	/*=============================================
	ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
	=============================================*/

	if(localStorage.getItem("quitarProducto") == null){

		idQuitarProducto = [];
	
	}else{

		idQuitarProducto.concat(localStorage.getItem("quitarProducto"))

	}

	idQuitarProducto.push({"idProducto":idProducto});

	localStorage.setItem("quitarProducto", JSON.stringify(idQuitarProducto));

	$("button.recuperarBoton[idProducto='"+idProducto+"']").removeClass('btn-default');

	$("button.recuperarBoton[idProducto='"+idProducto+"']").addClass('btn-primary agregarProducto');

	if($(".nuevoProducto").children().length == 0){

		$("#nuevoImpuestoVenta").val(0);
		$("#nuevoTotalVenta").val(0);
		$("#totalVenta").val(0);
		$("#nuevoTotalVenta").attr("total",0);
		$("#TotalPagado").val(0);

	}else{

		// SUMAR TOTAL DE PRECIOS

    	sumarTotalPrecios()

    	// AGREGAR IMPUESTO
	        
        agregarImpuesto()

        // AGRUPAR PRODUCTOS EN FORMATO JSON

        listarProductos()

	}

})

/*=============================================
AGREGANDO PRODUCTOS DESDE EL BOTÓN PARA DISPOSITIVOS
=============================================*/

var numProducto = 0;

$(".btnAgregarProducto").click(function(){

	numProducto ++;

	var datos = new FormData();
	datos.append("traerProductos", "ok");

	$.ajax({

		url:"ajax/productos.ajax.php",
      	method: "POST",
      	data: datos,
      	cache: false,
      	contentType: false,
      	processData: false,
      	dataType:"json",
      	success:function(respuesta){
      	    
      	    	$(".nuevoProducto").append(

          	'<div class="row" style="padding:5px 15px">'+

			  '<!-- Descripción del producto -->'+
	          
	          '<div class="col-xs-6" style="padding-right:0px">'+
	          
	            '<div class="input-group">'+
	              
	              '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarProducto" idProducto><i class="fa fa-times"></i></button></span>'+

	              '<select class="form-control nuevaDescripcionProducto" id="producto'+numProducto+'" idProducto name="nuevaDescripcionProducto" required>'+

	              '<option>Seleccione el producto</option>'+

	              '</select>'+  

	            '</div>'+

	          '</div>'+

	          '<!-- Cantidad del producto -->'+

	          '<div class="col-xs-3 ingresoCantidad">'+
	            
	             '<input type="number" class="form-control nuevaCantidadProducto" name="nuevaCantidadProducto" min="1"  stock nuevoStock required>'+

	          '</div>' +

	          '<!-- Precio del producto -->'+

	          '<div class="col-xs-3 ingresoPrecio" style="padding-left:0px">'+

	            '<div class="input-group">'+

	             
	                 
	              '<input type="text" class="form-control nuevoPrecioProducto" precioReal="" onchange="cambios()" name="nuevoPrecioProducto" required>'+
	 
	            '</div>'+
	             
	          '</div>'+

	        '</div>');


	        // AGREGAR LOS PRODUCTOS AL SELECT 

	         respuesta.forEach(funcionForEach);

	         function funcionForEach(item, index){

	         	if(item.stock != 0){

		         	$("#producto"+numProducto).append(

						'<option idProducto="'+item.id+'" value="'+item.descripcion+'">'+item.descripcion+'</option>'
		         	)

		         
		         }	         

	         }

        	 // SUMAR TOTAL DE PRECIOS

    		sumarTotalPrecios()

    		// AGREGAR IMPUESTO
	        
	        agregarImpuesto()

	        // PONER FORMATO AL PRECIO DE LOS PRODUCTOS

	        $(".nuevoPrecioProducto").number(true, 0);


      	}

	})

})

/*=============================================
SELECCIONAR PRODUCTO
=============================================*/

$(".formularioVenta").on("change", "select.nuevaDescripcionProducto", function(){

	var nombreProducto = $(this).val();

	var nuevaDescripcionProducto = $(this).parent().parent().parent().children().children().children(".nuevaDescripcionProducto");

	var nuevoPrecioProducto = $(this).parent().parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");

	var nuevaCantidadProducto = $(this).parent().parent().parent().children(".ingresoCantidad").children(".nuevaCantidadProducto");

	var datos = new FormData();
    datos.append("nombreProducto", nombreProducto);


	  $.ajax({

     	url:"ajax/productos.ajax.php",
      	method: "POST",
      	data: datos,
      	cache: false,
      	contentType: false,
      	processData: false,
      	dataType:"json",
      	success:function(respuesta){
      	    
      	     $(nuevaDescripcionProducto).attr("idProducto", respuesta["id"]);
      	    $(nuevaCantidadProducto).attr("stock", respuesta["stock"]);
      	    $(nuevaCantidadProducto).attr("nuevoStock", Number(respuesta["stock"])-1);
      	    $(nuevoPrecioProducto).val(respuesta["precio_venta"]);
      	    $(nuevoPrecioProducto).attr("precioReal", respuesta["precio_venta"]);

  	      // AGRUPAR PRODUCTOS EN FORMATO JSON

	        listarProductos()

      	}

      })
})

/*=============================================
MODIFICAR LA CANTIDAD
=============================================*/

$(".formularioVenta").on("change", "input.nuevaCantidadProducto", function(){

	var precio = $(this).parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");

	var precioFinal = $(this).val() * precio.attr("precioReal");
	
	precio.val(precioFinal);

	var nuevoStock = Number($(this).attr("stock")) - $(this).val();

	$(this).attr("nuevoStock", nuevoStock);

	if(Number($(this).val()) > Number($(this).attr("stock"))){

		/*=============================================
		SI LA CANTIDAD ES SUPERIOR AL STOCK REGRESAR VALORES INICIALES
		=============================================*/

		$(this).val(0);

		$(this).attr("nuevoStock", $(this).attr("stock"));

		var precioFinal = $(this).val() * precio.attr("precioReal");

		precio.val(precioFinal);

		sumarTotalPrecios();

		swal({
	      title: "La cantidad supera el Stock",
	      text: "¡Sólo hay "+$(this).attr("stock")+" unidades!",
	      type: "error",
	      confirmButtonText: "¡Cerrar!"
	    });

	    return;

	}

	// SUMAR TOTAL DE PRECIOS

	sumarTotalPrecios()

	// AGREGAR IMPUESTO
	        
    agregarImpuesto()

    // AGRUPAR PRODUCTOS EN FORMATO JSON

    listarProductos()

})

/*=============================================
SUMAR TODOS LOS PRECIOS
=============================================*/

function sumarTotalPrecios(){

	var precioItem = $(".nuevoPrecioProducto");
	
	var arraySumaPrecio = [];  

	for(var i = 0; i < precioItem.length; i++){

		 arraySumaPrecio.push(Number($(precioItem[i]).val()));
		
		 
	}

	function sumaArrayPrecios(total, numero){

		return total + numero;

	}

	var sumaTotalPrecio = arraySumaPrecio.reduce(sumaArrayPrecios);
	
	$("#nuevoTotalVenta").val(sumaTotalPrecio);
	$("#totalVenta").val(sumaTotalPrecio);
	$("#nuevoTotalVenta").attr("total",sumaTotalPrecio);
	

}

/*=============================================
FUNCIÓN AGREGAR IMPUESTO
=============================================*/

function agregarImpuesto(){

	var descuento = $("#nuevoDescuentoVenta").val();
	var impuesto = $("#nuevoImpuestoVenta").val();
	var precioTotal = $("#nuevoTotalVenta").attr("total");
	

	var precioImpuesto = Number(precioTotal * impuesto/100);

	var totalConImpuesto = Number(precioImpuesto) + Number(precioTotal) - Number(descuento);
	
	var result = Number(totalConImpuesto - descuento);

	$("#nuevoTotalVenta").val(totalConImpuesto);

	$("#totalVenta").val(totalConImpuesto);

	$("#nuevoPrecioImpuesto").val(precioImpuesto);

	$("#nuevoPrecioNeto").val(precioTotal);

}

function restar(){

	var total = $("#TotalPendientePago2").val();

	var pagado  = $("#TotalPagado").val();

	var pendiente = Number(total - pagado);

	$("#TotalPendientePago").val(pendiente);


}


function restar3(){

	var total = $("#TotalVenta").val();

	var pagado  = $("#TotalPagado").val();

	var pendiente = Number(total - pagado);

	$("#TotalPendientePago2").val(pendiente);


}

function restar2(){

	var total = $("#totalVenta").val();

	var pagado  = $("#TotalPagado").val();

	var pendiente = Number(total - pagado);

	$("#TotalPendientePago").val(pendiente);


}

function desc(){
	var descuento = $("#nuevoDescuentoVenta").val();
	var total = $("#TotalPendientePago").val();

	var total_desc = Number(total - descuento);

	$("#TotalPendientePago2").val(total_desc);

}


/*=============================================
FUNCION AL PICHAR APAREZCA EL PRECIO
=============================================*/

$(function(){
	$(document).on('change','#nuevoMetodoPago',function(){ //detectamos el evento change
	  var value = $('#nuevoTotalVenta').val();//sacamos el valor del select
	$('#nuevoValorEfectivo').val(value);
	$('#nuevoValorCheque').val(value);
	$('#nuevoValorTransferencia').val(value);
	$('#nuevoValorDeposito').val(value);
  });
});

$(function(){
	$(document).on('change','#nuevoMetodoPago',function(){ //detectamos el evento change
	  var value = $('#nuevoTotalVenta').val();//sacamos el valor del select
	$('#nuevoCambioPendientePago').val(value);

  });
});


/*=============================================
FUNCION DE COPIAR DESDE nuevoTotalVenta A totalVenta
=============================================*/

$(document).ready(function () {
    $("#nuevoTotalVenta").keyup(function () {
        var value = $(this).val();
        $("#totalVenta").val(value);
    });
});

$(document).ready(function(){
	$("#seleccionarCliente").select2();
	
	});



$(document).ready(function(){
	$("#seleccionarCliente").select2();
	
	});



$(document).ready(function(){
	$("#seleccionarCliente").select2();
	
	});


/*=============================================
CUANDO CAMBIA EL IMPUESTO
=============================================*/

$("#nuevoImpuestoVenta").change(function(){

	agregarImpuesto();

});

$("#TotalPendientePago").change(function(){
	
	desc();


});


$("#nuevoDescuentoVenta").change(function(){
	
	agregarImpuesto();
	desc();


});

/*=============================================
FORMATO AL PRECIO FINAL
=============================================*/

$("#nuevoTotalVenta").number(true, 0);

/*=============================================
SELECCIONAR MÉTODO DE PAGO
=============================================*/

$("#nuevoMetodoPago").change(function(){

	var metodo = $(this).val();
	var metodo2 = $(this).val();
	var metodo3 = $(this).val();
	var metodo4 = $(this).val();
	var metodo5 = $(this).val();


	if(metodo == "Efectivo"){

		$(this).parent().parent().removeClass("col-xs-6");

		$(this).parent().parent().addClass("col-xs-4");

		$(this).parent().parent().parent().children(".cajasMetodoPago").html(

			 '<div class="col-xs-4">'+ 

			 	'<div class="input-group" style="position: relative; bottom: 38px;">'+ 
			 	
			 	 '<h4><small style="color:black; font-weight: bold;">Pagado</small></h4>'+ 

			 		'<input type="number" class="form-control cal" id="nuevoValorEfectivo" name="TotalPagado" onkeyup="restar2()" placeholder="000000" required>'+

			 	'</div>'+

			 '</div>'+

			 '<div class="col-xs-4" id="capturarCambioEfectivo" style="padding-left:0px">'+

			 	'<div class="input-group" style="position: relative; bottom: 38px;">'+
			 	
			 	 '<h4><small style="color:black; font-weight: bold;">Pendiente Pago</small></h4>'+ 


			 		'<input type="number" class="form-control cal" id="nuevoCambioEfectivo" name="TotalPendientePago" placeholder="000000"  readonly required  value="0">'+

			 	'</div>'+

			 '</div>'

		 )

		// Agregar formato al precio

		$('#nuevoValorEfectivo').number( true, 0);
      	$('#nuevoCambioEfectivo').number( true, 0);


      	// Listar método en la entrada
      	listarMetodos()

	}

if(metodo2 == "Cheque"){

		$(this).parent().parent().removeClass("col-xs-6");

		$(this).parent().parent().addClass("col-xs-4");

		$(this).parent().parent().parent().children(".cajasMetodoPago").html(

			 '<div class="col-xs-4">'+ 

			 	'<div class="input-group" style="position: relative; bottom: 38px">'+ 

				 '<h4><small  style="color:black; font-weight: bold;">Pagado</small></h4>'+ 

			 		'<input type="number" class="form-control cal" id="nuevoValorCheque" name="TotalPagado"  placeholder="000000" required>'+

				 
				 '</div>'+

			 '</div>'+

			 '<div class="col-xs-4" id="capturarCambioCheque" style="padding-left:0px">'+

			 	'<div class="input-group" style="position: relative; bottom: 38px">'+

				 '<h4><small  style="color:black; font-weight: bold;">Pendiente Pago</small></h4>'+ 

			 		'<input type="number" class="form-control cal" id="nuevoCambioCheque" name="TotalPendientePago" value="0" readonly required>'+

				 '</div>'+

			 '</div>'

		 )

		// Agregar formato al precio

		$('#nuevoValorCheque').number( true, 0);
      	$('#nuevoCambioCheque').number( true, 0);


      	// Listar método en la entrada
      	listarMetodos()

	}

	if(metodo3 == "Transferencia"){

		$(this).parent().parent().removeClass("col-xs-6");

		$(this).parent().parent().addClass("col-xs-4");

		$(this).parent().parent().parent().children(".cajasMetodoPago").html(

			 '<div class="col-xs-4">'+ 

			 	'<div class="input-group"  style="position: relative; bottom: 38px;">'+ 

				 '<h4><small  style="color:black; font-weight: bold;">Pagado</small></h4>'+ 

			 		'<input type="number" class="form-control" id="nuevoValorTransferencia" name="TotalPagado" placeholder="000000" required>'+

				 '</div>'+

			 '</div>'+

			 '<div class="col-xs-4" id="capturarCambioTransferencia" style="padding-left:0px">'+

			 	'<div class="input-group"  style="position: relative; bottom: 38px;">'+

				 '<h4><small  style="color:black; font-weight: bold;">Pendiente Pago</small></h4>'+ 

			 		'<input type="number" class="form-control" id="nuevoCambioTransferencia" name="TotalPendientePago" value="0" readonly required>'+

				 '</div>'+

			 '</div>'

		 )

		// Agregar formato al precio

		$('#nuevoValorTransferencia').number( true, 0);
      	$('#nuevoCambioTransferencia').number( true, 0);


      	// Listar método en la entrada
      	listarMetodos()

	}

	if(metodo4 == "Deposito"){

		$(this).parent().parent().removeClass("col-xs-6");

		$(this).parent().parent().addClass("col-xs-4");

		$(this).parent().parent().parent().children(".cajasMetodoPago").html(

			 '<div class="col-xs-4">'+ 

			 	'<div class="input-group" style="position: relative; bottom: 38px;">'+ 

				 '<h4><small  style="color:black; font-weight: bold;">Pagado</small></h4>'+ 

			 		'<input type="number" class="form-control" id="nuevoValorDeposito" name="TotalPagado" placeholder="000000" required>'+
				 
				 '</div>'+

			 '</div>'+

			 '<div class="col-xs-4" id="capturarCambioDeposito" style="padding-left:0px">'+

			 	'<div class="input-group"  style="position: relative; bottom: 38px;">'+

				 '<h4><small  style="color:black; font-weight: bold;">Pendiente Pago</small></h4>'+ 

			 		'<input type="number" class="form-control" id="nuevoCambioDeposito" name="TotalPendientePago" value="0" readonly required>'+
				 
				 '</div>'+

			 '</div>'

		 )

		// Agregar formato al precio

		$('#nuevoValorDeposito').number( true, 0);
      	$('#nuevoCambioDeposito').number( true, 0);


      	// Listar método en la entrada
      	listarMetodos()

	}

	if(metodo5 == "Pendiente pago"){

		$(this).parent().parent().removeClass("col-xs-6");

		$(this).parent().parent().addClass("col-xs-4");

		$(this).parent().parent().parent().children(".cajasMetodoPago").html(

			 '<div class="col-xs-4">'+ 

				 '<div class="input-group" style="position: relative; bottom: 38px;">'+ 
				 
			 		'<h4><small  style="color:black; font-weight: bold;">Pagado</small></h4>'+ 

					 '<input type="number" class="form-control" id="nuevoValorPendientePago" name="TotalPagado" value="0" required>'+
					 
			 	'</div>'+

			 '</div>'+

			 '<div class="col-xs-4" id="capturarCambioPendientePago" style="padding-left:0px">'+

			 	'<div class="input-group" style="position: relative; bottom: 38px;">'+
			 	
				 '<h4><small  style="color:black; font-weight: bold;">Pendiente Pago</small></h4>'+ 

			 		'<input type="number" class="form-control" id="nuevoCambioPendientePago" name="TotalPendientePago" placeholder="000000" readonly required>'+

			 	'</div>'+

			 '</div>'

		 )

		// Agregar formato al precio

		$('#nuevoValorPendientePago').number( true, 0);
      	$('#nuevoCambioPendientePago').number( true, 0);


      	// Listar método en la entrada
      	listarMetodos()

	}


})

/*=============================================
CAMBIO EN EFECTIVO
=============================================*/
$(".formularioVenta").on("keyup", "input#nuevoValorEfectivo", function(){

	var efectivo = $(this).val();

	var cambio =  Number($('#nuevoTotalVenta').val()) - Number(efectivo);

	var nuevoCambioEfectivo = $(this).parent().parent().parent().children('#capturarCambioEfectivo').children().children('#nuevoCambioEfectivo');

	nuevoCambioEfectivo.val(cambio);

})

/*=============================================
CAMBIO EN CHEQUE
=============================================*/
$(".formularioVenta").on("change", "input#nuevoValorCheque", function(){

	var cheque = $(this).val();

	var cambio =  Number($('#nuevoTotalVenta').val()) - Number(cheque);

	var nuevoCambioCheque = $(this).parent().parent().parent().children('#capturarCambioCheque').children().children('#nuevoCambioCheque');

	nuevoCambioCheque.val(cambio);

})

/*=============================================
CAMBIO EN TRANSFERENCIA
=============================================*/
$(".formularioVenta").on("change", "input#nuevoValorTransferencia", function(){

	var transferencia = $(this).val();

	var cambio =  Number($('#nuevoTotalVenta').val()) - Number(transferencia);

	var nuevoCambioTransferencia = $(this).parent().parent().parent().children('#capturarCambioTransferencia').children().children('#nuevoCambioTransferencia');

	nuevoCambioTransferencia.val(cambio);

})


/*=============================================
CAMBIO EN DEPOSITO
=============================================*/
$(".formularioVenta").on("change", "input#nuevoValorDeposito", function(){

	var deposito = $(this).val();

	var cambio =  Number($('#nuevoTotalVenta').val()) - Number(deposito);

	var nuevoCambioDeposito = $(this).parent().parent().parent().children('#capturarCambioDeposito').children().children('#nuevoCambioDeposito');

	nuevoCambioDeposito.val(cambio);

})

/*=============================================
CAMBIO EN PENDIENTE PAGO
=============================================*/
$(".formularioVenta").on("change", "input#nuevoValorPendientePago", function(){

	var pendiente = $(this).val();

	var cambio =  Number($('#nuevoTotalVenta').val()) - Number(pendiente);

	var nuevoCambioPendientePago = $(this).parent().parent().parent().children('#capturarCambioPendientePago').children().children('#nuevoCambioPendientePago');

	nuevoCambioPendientePago.val(cambio);

})





















/*=============================================
CAMBIO TRANSACCIÓN
=============================================*/
$(".formularioVenta").on("change", "input#nuevoCodigoTransaccion", function(){

	// Listar método en la entrada
     listarMetodos()


})


/*=============================================
LISTAR TODOS LOS PRODUCTOS
=============================================*/

function listarProductos(){

	var listaProductos = [];

	var descripcion = $(".nuevaDescripcionProducto");

	var cantidad = $(".nuevaCantidadProducto");

	var precio = $(".nuevoPrecioProducto");

	for(var i = 0; i < descripcion.length; i++){

		listaProductos.push({ "id" : $(descripcion[i]).attr("idProducto"), 
							  "descripcion" : $(descripcion[i]).val(),
							  "cantidad" : $(cantidad[i]).val(),
							  "stock" : $(cantidad[i]).attr("nuevoStock"),
							  "precio" : $(precio[i]).attr("precioReal"),
							  "total" : $(precio[i]).val()})

	}

	$("#listaProductos").val(JSON.stringify(listaProductos)); 

}

/*=============================================
LISTAR MÉTODO DE PAGO
=============================================*/

function listarMetodos(){

	var listaMetodos = "";

	if($("#nuevoMetodoPago").val() == "Efectivo"){

		$("#listaMetodoPago").val("Efectivo");
		

	}if($("#nuevoMetodoPago").val() == "Cheque"){

		$("#listaMetodoPago").val("Cheque");	


	}if($("#nuevoMetodoPago").val() == "Transferencia"){

		$("#listaMetodoPago").val("Transferencia");	


	}if($("#nuevoMetodoPago").val() == "Deposito"){

		$("#listaMetodoPago").val("Deposito");		
		

	}if($("#nuevoMetodoPago").val() == "Pendiente pago"){

		$("#listaMetodoPago").val("Pendiente pago");		

	}

}

/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablas").on("click", ".btnEditarVenta", function(){

	var idVenta = $(this).attr("idVenta");

	window.location = "index.php?ruta=editar-venta&idVenta="+idVenta;


})

/*=============================================
BOTON VER HISTORIAL VENTAS
=============================================*/
$(".tablas").on("click", ".btnHistorial", function(){

	var codigoVenta = $(this).attr("codigoVenta");

	window.location = "index.php?ruta=historial-venta&codigoVenta="+codigoVenta;





})


/*=============================================
FUNCIÓN PARA DESACTIVAR LOS BOTONES AGREGAR CUANDO EL PRODUCTO YA HABÍA SIDO SELECCIONADO EN LA CARPETA
=============================================*/

function quitarAgregarProducto(){

	//Capturamos todos los id de productos que fueron elegidos en la venta
	var idProductos = $(".quitarProducto");

	//Capturamos todos los botones de agregar que aparecen en la tabla
	var botonesTabla = $(".tablaVentas tbody button.agregarProducto");

	//Recorremos en un ciclo para obtener los diferentes idProductos que fueron agregados a la venta
	for(var i = 0; i < idProductos.length; i++){

		//Capturamos los Id de los productos agregados a la venta
		var boton = $(idProductos[i]).attr("idProducto");
		
		//Hacemos un recorrido por la tabla que aparece para desactivar los botones de agregar
		for(var j = 0; j < botonesTabla.length; j ++){

			if($(botonesTabla[j]).attr("idProducto") == boton){

				$(botonesTabla[j]).removeClass("btn-primary agregarProducto");
				$(botonesTabla[j]).addClass("btn-default");

			}
		}

	}
	
}

/*=============================================
CADA VEZ QUE CARGUE LA TABLA CUANDO NAVEGAMOS EN ELLA EJECUTAR LA FUNCIÓN:
=============================================*/

$('.tablaVentas').on( 'draw.dt', function(){

	quitarAgregarProducto();

})


/*=============================================
BORRAR VENTA
=============================================*/
$(".tablas").on("click", ".btnEliminarVenta", function(){

  var idVenta = $(this).attr("idVenta");

  swal({
        title: '¿Está seguro de borrar la venta?',
        text: "¡Si no lo está puede cancelar la accíón!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar venta!'
      }).then(function(result){
        if (result.value) {
          
            window.location = "index.php?ruta=ventas&idVenta="+idVenta;
        }

  })

})

/*=============================================
IMPRIMIR FACTURA
=============================================*/

$(".tablas").on("click", ".btnImprimirFactura", function(){

	var codigoVenta = $(this).attr("codigoVenta");

	window.open("extensiones/tcpdf/pdf/factura.php?codigo="+codigoVenta, "_blank"); 

})


/*=============================================
BOTON PARA VER FACTURA HISTORIAL DE VENTAS
=============================================*/


$(".tablas").on("click", ".btnImprimirHistorial", function(){

	var codigoVenta = $(this).attr("codigoVenta");

	window.open("extensiones/tcpdf/pdf/historial_ventas.php?codigo="+codigoVenta, "_blank"); 

})

/*=============================================
IMPRIMIR Ticket
=============================================*/

$(".tablas").on("click", ".btnImprimirTicket", function(){

	var codigoVenta = $(this).attr("codigoVenta");

	window.open("extensiones/tcpdf/pdf/ticket.php?codigo="+codigoVenta, "_blank"); 

})


/*=============================================
RANGO DE FECHAS
=============================================*/

$('#daterange-btn-venta').daterangepicker(
	{

	 "locale": {
      "format": "YYYY-MM-DD",
      "separator": " - ",
      "applyLabel": "Aplicar",
      "cancelLabel": "Cancelar",
      "fromLabel": "Desde",
      "toLabel": "Hasta",
      "customRangeLabel": "Rango Personalizado",
      "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
      ],
      "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
      ],
      "firstDay": 1
    },
    ranges   : {
      'Hoy'       : [moment(), moment()],
      'Ayer'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días' : [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este Mes'  : [moment().startOf('month'), moment().endOf('month')],
      'Último Mes'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'Este Año': [moment().startOf('year'), moment().endOf('year')],
      'Último Año'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
    },
	
	  /*ranges   : {
		'Hoy'       : [moment(), moment()],
		'Ayer'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		'Últimos 7 días' : [moment().subtract(6, 'days'), moment()],
		'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
		'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
		'Último mes'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
		'Este Año': [moment().startOf('year'), moment().endOf('year')],
		'Último Año'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
	  },*/
  
	  startDate: moment().subtract(6, 'days'),
	  endDate  : moment().subtract(6, 'days')
	},
	function (fechaInicial, fechaFinal) {
		
  
	
	 window.location.href = "index.php?ruta=ventas&fechaInicial="+fechaInicial.format('YYYY-MM-DD')+"&fechaFinal="+fechaFinal.format('YYYY-MM-DD');
	
	},
  
  
  )



/*=============================================
ABRIR ARCHIVO XML EN NUEVA PESTAÑA
=============================================*/

$(".abrirXML").click(function(){

	var archivo = $(this).attr("archivo");
	window.open(archivo, "_blank");


})

