

/*=============================================
Data Table Admin
=============================================*/

var admin = $("#admin").val();
var vendedor = $("#vendedor").val();

let between1 = $("#between1").val();
let between2 = $("#between2").val();

if(admin){
 var table = $(".tablaAdVentas").DataTable({
	
	"searching": true,
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"serverSide": true,
	"serverMethod": 'POST',

	'ajax': {
			'url': 'ajax/serversideVentas.ajax.php?between1=' + between1 + '&between2=' + between2

	},  


	   "order": [0, 'desc'],


	   "lengthMenu": [[10, 20, 50, 3000, 10000000], [10, 20, 50, 3000, "Todos"]],

	"columns":[ 

		

		{data: 'id', visible: false},
		{data: 'codigo',


		render : function (data, type, row) {
	
				
					return +row.codigo+ ' <button class="btn btn-success btn-sm btnImprimirTicket"><i class="fa fa-print"></i></button>' 
				
	
			}
         },
		{data: 'id_cliente'},
        {data: 'total_pendiente_pago'},
        {data: 'total'},
		{data: 'fecha'},
        {data: 'descuento'},
		{data: 'total_pagado'},
		{data: 'id_vendedor'},
	


		{
			"targets": -1,  
		
	
		"defaultContent": "<div class=''>"+
		'<div class="btn-group">'+
		
		'<button class="btn btn-info btn-sm btnImprimirFactura">PDF</button>'+
		'<button class="btn btn-warning btn-sm btnEditarVenta"><i class="fa fa-pencil"></i></button>'+
       ' <button class="btn btn-primary btn-sm btnHistorial"><i class="fa fa-search"></i></button>'+
		'<button id="btnEliminar" class="btn btn-danger btn-sm btnEliminarVenta"><i class="fa fa-times"></i></button>'+
	
	


		'</div>'+
		'</div>'
		}

		


	],
	





	dom: '<Bl<f>rtip>',
	buttons: [		          
		'copy', 'csv', 'excel', 'pdf', 'print'
	],

	

	"language": {

		"sProcessing":     "Procesando...",
		"sLengthMenu":     "Mostrar _MENU_ registros",
		"sZeroRecords":    "No se encontraron resultados",
		"sEmptyTable":     "Ningún dato disponible en esta tabla",
		"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix":    "",
		"sSearch":         "Buscar:",
		"sUrl":            "",
		"sInfoThousands":  ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
		"sFirst":    "Primero",
		"sLast":     "Último",
		"sNext":     "Siguiente",
		"sPrevious": "Anterior"
		},
		"buttons": {
            "copyTitle": "Tabla Copiada",
            "copySuccess": {
                    _: '%d líneas copiadas',
                    1: '1 línea copiada'
                }
            },
		"oAria": {
			"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}
	}


	

});


/*=============================================
Data Table Vendedor
=============================================*/

}else if(vendedor){

var table = $(".tablaAdVentas").DataTable({

	
		"searching": true,
		"deferRender": true,
		"retrieve": true,
		"processing": true,
		"serverSide": true,
		"serverMethod": 'POST',
	
		'ajax': {
				'url': 'ajax/serversideVentas.ajax.php?between1=' + between1 + '&between2=' + between2
	
		},  

			
		   "order": [0, 'desc'],
	
		"columns":[ 
	
			

			{data: 'id', visible: false},
			{data: 'codigo',
	
	
			render : function (data, type, row) {
		
					
			return +row.codigo+ ' <button class="btn btn-success btn-sm btnImprimirTicket"><i class="fa fa-print"></i></button>' 
					
		
				}
			 },
			{data: 'id_cliente'},
			{data: 'total_pendiente_pago'},
			{data: 'total'},
			{data: 'fecha'},
			{data: 'descuento'},
			{data: 'total_pagado'},
			{data: 'id_vendedor'},
			
			{
				"targets": -1,  
			
		
			"defaultContent": "<div class=''>"+
			'<div class="btn-group">'+
			
			'<button class="btn btn-warning btn-sm btnEditarVenta"><i class="fa fa-pencil"></i></button>'+
			'<button class="btn btn-primary btn-sm btnHistorial"><i class="fa fa-search"></i></button>'+
		
		
	
	
			'</div>'+
			'</div>'
			}
	
	
		],
	
	
	
		dom: '<Bl<f>rtip>',
		buttons: [		          
			'copy', 'csv', 'excel', 'pdf', 'print'
		],
	
		order: [ 0, 'desc' ],
	
		"language": {
	
			"sProcessing":     "Procesando...",
			"sLengthMenu":     "Mostrar _MENU_ registros",
			"sZeroRecords":    "No se encontraron resultados",
			"sEmptyTable":     "Ningún dato disponible en esta tabla",
			"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
			"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
			"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
			"sInfoPostFix":    "",
			"sSearch":         "Buscar:",
			"sUrl":            "",
			"sInfoThousands":  ",",
			"sLoadingRecords": "Cargando...",
			"oPaginate": {
			"sFirst":    "Primero",
			"sLast":     "Último",
			"sNext":     "Siguiente",
			"sPrevious": "Anterior"
			},
			"buttons": {
				"copyTitle": "Tabla Copiada",
				"copySuccess": {
						_: '%d líneas copiadas',
						1: '1 línea copiada'
					}
				},
			"oAria": {
				"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
				"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			}
	
		}
	
	});

}


/*=============================================
BOTON EDITAR VENTA
=============================================*/

$(".tablaAdVentas").on("click", ".btnEditarVenta", function(){

	let rowData = table.row($(this).parents("tr")).data();
    
    if (rowData) {
        let idVenta = rowData.id;
		window.location = "index.php?ruta=editar-venta&idVenta="+idVenta;
    }


}) 




/*=============================================
IMPRIMIR Ticket
=============================================*/

$(".tablaAdVentas").on("click", ".btnImprimirTicket", function(){

	fila = $(this).closest("tr");
	codigoId = parseInt(fila.find('td:eq(0)').text()); //capturo el ID

	//var codigoVenta = $(this).attr("codigoVenta");

	window.open("extensiones/tcpdf/pdf/ticket.php?codigo="+codigoId, "_blank"); 

})

/*=============================================
IMPRIMIR Ticket DIRECTO	
=============================================*/

$(".tablaAdVentas").on("click", ".btnImprimirTicket2", function(){

	fila = $(this).closest("tr");
	codigoId = parseInt(fila.find('td:eq(0)').text()); //capturo el ID



	window.location = "index.php?ruta=ticket&codigoId="+codigoId;

})

/*=============================================
IMPRIMIR FACTURA
=============================================*/

$(".tablaAdVentas").on("click", ".btnImprimirFactura", function(){

	fila = $(this).closest("tr");
	codigoId = parseInt(fila.find('td:eq(0)').text()); //capturo el ID

	//var codigoVenta = $(this).attr("codigoVenta");

	window.open("extensiones/tcpdf/pdf/factura.php?codigo="+codigoId, "_blank"); 

})

/*=============================================
BOTON VER HISTORIAL VENTAS
=============================================*/
$(".tablaAdVentas").on("click", ".btnHistorial", function(){

	fila = $(this).closest("tr");
	codigoId = parseInt(fila.find('td:eq(0)').text()); //capturo el codigo

	window.location = "index.php?ruta=historial-venta&codigoVenta="+codigoId;




})



/*=============================================
BORRAR VENTA
=============================================*/
$(".tablaAdVentas").on("click", ".btnEliminarVenta", function(){

	let rowData = table.row($(this).parents("tr")).data();
    
      swal({
        title: '¿Está seguro de borrar la venta?',
        text: "¡Si no lo está puede cancelar la accíón!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar venta!'
      }).then(function(result){
        if (result.value) {
          
			if (rowData) {
				let idVenta = rowData.id;
				window.location = "index.php?ruta=ventas&idVenta="+idVenta;
			}
        }

  })

	//console.log("idVenta", idVenta)
  
  })

 


